/*
Navicat PGSQL Data Transfer

Source Server         : Local PostgresQL
Source Server Version : 90004
Source Host           : localhost:5432
Source Database       : deer_spt
Source Schema         : claims

Target Server Type    : PGSQL
Target Server Version : 90004
File Encoding         : 65001

Date: 2011-11-29 19:36:30
*/


-- ----------------------------
-- Table structure for "claims"."ClaimVersionType"
-- ----------------------------
DROP TABLE "claims"."ClaimVersionType";
CREATE TABLE "claims"."ClaimVersionType" (
"Code" varchar(16) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of ClaimVersionType
-- ----------------------------
INSERT INTO "claims"."ClaimVersionType" VALUES ('EDExAnteFix', 'ED fix to ex ante claim', '');
INSERT INTO "claims"."ClaimVersionType" VALUES ('EDExAnteUp', 'ED update to ex ante claim', '');
INSERT INTO "claims"."ClaimVersionType" VALUES ('ExAnteFix', 'IOU fix to ex ante claim', '');
INSERT INTO "claims"."ClaimVersionType" VALUES ('ExAnteUp', 'IOU update to ex ante claim', '   augmented as necessary');
INSERT INTO "claims"."ClaimVersionType" VALUES ('ExPost', '', '');
INSERT INTO "claims"."ClaimVersionType" VALUES ('InitExAnte', 'IOU initial submittal of this claim', 'examples to be replaced and ');

-- ----------------------------
-- Table structure for "claims"."EECycle"
-- ----------------------------
DROP TABLE "claims"."EECycle";
CREATE TABLE "claims"."EECycle" (
"Code" varchar(4) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of EECycle
-- ----------------------------
INSERT INTO "claims"."EECycle" VALUES ('0405', '2004 - 2005 cycle period', null);
INSERT INTO "claims"."EECycle" VALUES ('0608', '2006 - 2008 cycle period', null);
INSERT INTO "claims"."EECycle" VALUES ('1012', '2010 - 2012 cycle period', '');
INSERT INTO "claims"."EECycle" VALUES ('1315', '2013-2015 cycle period', '');
INSERT INTO "claims"."EECycle" VALUES ('2009', '2009 bridge period', '');

-- ----------------------------
-- Table structure for "claims"."IOU Programs"
-- ----------------------------
DROP TABLE "claims"."IOU Programs";
CREATE TABLE "claims"."IOU Programs" (
"Program ID" varchar(255) NOT NULL,
"Program Name" varchar(255),
"Cycle" varchar(255),
"IOU" varchar(255),
"Program Implementor" varchar(255),
"Target Market" varchar(255),
"Program Category" varchar(255),
"Program Type" varchar(255),
"Measure Impact Type" varchar(255),
"Custom Upload" bool
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of IOU Programs
-- ----------------------------

-- ----------------------------
-- Table structure for "claims"."ReportPeriod"
-- ----------------------------
DROP TABLE "claims"."ReportPeriod";
CREATE TABLE "claims"."ReportPeriod" (
"Code" varchar(7) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of ReportPeriod
-- ----------------------------
INSERT INTO "claims"."ReportPeriod" VALUES ('2009_1Q', '2009 first quarter reporting period', 'entries to be augmented ');
INSERT INTO "claims"."ReportPeriod" VALUES ('2009_2Q', '2009 second quarter reporting period', '   as necessary');
INSERT INTO "claims"."ReportPeriod" VALUES ('2009_3Q', '2009 third quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2009_4Q', '2009 forth quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2009_Yr', '2009 reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2010_1Q', '2010 first quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2010_2Q', '2010 second quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2010_3Q', '2010 third quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2010_4Q', '2010 forth quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2010_Yr', '2010 reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2011_1Q', '2011 first quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2011_2Q', '2011 second quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2011_3Q', '2011 third quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2011_4Q', '2011 forth quarter reporting period', '');
INSERT INTO "claims"."ReportPeriod" VALUES ('2011_Yr', '2011 reporting period', '');

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table "claims"."ClaimVersionType"
-- ----------------------------
ALTER TABLE "claims"."ClaimVersionType" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Primary Key structure for table "claims"."EECycle"
-- ----------------------------
ALTER TABLE "claims"."EECycle" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Primary Key structure for table "claims"."IOU Programs"
-- ----------------------------
ALTER TABLE "claims"."IOU Programs" ADD PRIMARY KEY ("Program ID");

-- ----------------------------
-- Primary Key structure for table "claims"."ReportPeriod"
-- ----------------------------
ALTER TABLE "claims"."ReportPeriod" ADD PRIMARY KEY ("Code");
