-- Create the location weight multiplied version of the measure impacts table (to be summed later), 
--  Note: the results for the New vintage is not PA specific, so the weights table is linked differently 
SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_tmp2;
CREATE TABLE meas_impacts_tmp2 AS 
SELECT
"EnergyImpactID",
meas_impacts_wtd."PA",
meas_impacts_wtd."BldgType",
meas_impacts_wtd."BldgVint",
meas_impacts_wtd."BldgLoc",
meas_impacts_wtd."BldgHVAC",
sum_loc as "wt_loc",
"NormUnit",
"NumUnit" * sum_loc as "NumUnit",
"MeasArea" * sum_loc   as "MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh" * sum_loc   as "APreWBkWh",
"APreWBkW" * sum_loc    as "APreWBkW",
"APreWBtherm" * sum_loc as "APreWBtherm",
"AStdWBkWh" * sum_loc   as "AStdWBkWh",
"AStdWBkW" * sum_loc    as "AStdWBkW",
"AStdWBtherm" * sum_loc as "AStdWBtherm"
from meas_impacts_wtd
JOIN wts_com_loc on 
 wts_com_loc.pa       = meas_impacts_wtd."PA" and 
 wts_com_loc.bldgtype = meas_impacts_wtd."BldgType" and 
 wts_com_loc.era      = meas_impacts_wtd."BldgVint" and 
 wts_com_loc.bldgloc  = meas_impacts_wtd."BldgLoc"
WHERE meas_impacts_wtd."BldgVint" <> 'New'

UNION

SELECT
"EnergyImpactID",
wts_com_loc.pa as "PA",
meas_impacts_wtd."BldgType",
meas_impacts_wtd."BldgVint",
meas_impacts_wtd."BldgLoc",
meas_impacts_wtd."BldgHVAC",
sum_loc as "wt_loc",
"NormUnit",
"NumUnit" * sum_loc as "NumUnit",
"MeasArea" * sum_loc   as "MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh" * sum_loc   as "APreWBkWh",
"APreWBkW" * sum_loc    as "APreWBkW",
"APreWBtherm" * sum_loc as "APreWBtherm",
"AStdWBkWh" * sum_loc   as "AStdWBkWh",
"AStdWBkW" * sum_loc    as "AStdWBkW",
"AStdWBtherm" * sum_loc as "AStdWBtherm"
from meas_impacts_wtd
JOIN wts_com_loc on 
 wts_com_loc.bldgtype = meas_impacts_wtd."BldgType" and 
 wts_com_loc.era      = meas_impacts_wtd."BldgVint" and 
 wts_com_loc.bldgloc  = meas_impacts_wtd."BldgLoc"
WHERE meas_impacts_wtd."BldgVint" = 'New'

ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC";

ALTER TABLE "meas_impacts_tmp2"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
