-- Create the location weight multiplied version of the measure impacts table (to be summed later), 
--  The weights table has to be linked differently for the New vintage for the climate-zone specific results
SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_tmp3;
CREATE TABLE meas_impacts_tmp3 AS 
SELECT
"EnergyImpactID",
meas_impacts_wtd."PA",
meas_impacts_wtd."BldgType",
meas_impacts_wtd."BldgVint",
meas_impacts_wtd."BldgLoc",
meas_impacts_wtd."BldgHVAC",
sum_bldg as "wt_bldg",
"NormUnit",
"NumUnit" * sum_bldg as "NumUnit",
"MeasArea" * sum_bldg   as "MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh" * sum_bldg   as "APreWBkWh",
"APreWBkW" * sum_bldg    as "APreWBkW",
"APreWBtherm" * sum_bldg as "APreWBtherm",
"AStdWBkWh" * sum_bldg   as "AStdWBkWh",
"AStdWBkW" * sum_bldg    as "AStdWBkW",
"AStdWBtherm" * sum_bldg as "AStdWBtherm"
from meas_impacts_wtd
LEFT JOIN wts_res_bldg on 
 wts_res_bldg.pa       = meas_impacts_wtd."PA" and 
 wts_res_bldg.bldgtype = meas_impacts_wtd."BldgType" and 
 wts_res_bldg.bldgloc  = meas_impacts_wtd."BldgLoc" and 
 wts_res_bldg.era      = meas_impacts_wtd."BldgVint"
WHERE meas_impacts_wtd."BldgType" <> 'Res' 
  and not ((meas_impacts_wtd."BldgVint" = 'New') AND (meas_impacts_wtd."BldgLoc" like 'CZ%'))

UNION

SELECT
"EnergyImpactID",
wts_res_bldg.pa AS "PA",
meas_impacts_wtd."BldgType",
meas_impacts_wtd."BldgVint",
meas_impacts_wtd."BldgLoc",
meas_impacts_wtd."BldgHVAC",
sum_bldg as "wt_bldg",
"NormUnit",
"NumUnit" * sum_bldg as "NumUnit",
"MeasArea" * sum_bldg   as "MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh" * sum_bldg   as "APreWBkWh",
"APreWBkW" * sum_bldg    as "APreWBkW",
"APreWBtherm" * sum_bldg as "APreWBtherm",
"AStdWBkWh" * sum_bldg   as "AStdWBkWh",
"AStdWBkW" * sum_bldg    as "AStdWBkW",
"AStdWBtherm" * sum_bldg as "AStdWBtherm"
from meas_impacts_wtd
LEFT JOIN wts_res_bldg on 
 wts_res_bldg.bldgtype = meas_impacts_wtd."BldgType" and 
 wts_res_bldg.bldgloc  = meas_impacts_wtd."BldgLoc" and 
 wts_res_bldg.era      = meas_impacts_wtd."BldgVint"
WHERE meas_impacts_wtd."BldgType" <> 'Res' 
  and ((meas_impacts_wtd."BldgVint" = 'New') AND (meas_impacts_wtd."BldgLoc" like 'CZ%'))

ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC";

ALTER TABLE "meas_impacts_tmp3"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
